// https://macsbug.wordpress.com/2017/12/26/gps-clock-with-m5stack/

// GPS CLOCK WITH M5STACK : 2017.12.26 : macsbug
#include <M5Stack.h>
#include "Free_Fonts.h"
#include <TinyGPS++.h>
TinyGPSPlus gps;
HardwareSerial gs(2);           // ESP32 UART2 GPIO-16 ( RXD2 ) --- GPS TXD

//=========================================================================
float    sx = 0,sy = 1,mx = 1,my = 0,hx = -1,hy = 0;
float    sdeg=0, mdeg=0, hdeg=0;
uint16_t osx=120,osy=120,omx=120,omy=120,ohx=120,ohy=120;
uint16_t x0=0, x1=0, yy0=0, yy1=0;
uint32_t targetTime = 0;                   // for next 1 second timeout
static uint8_t conv2d(const char* p);
uint8_t  hh=conv2d(__TIME__);              // Get H, M, S from compile time
uint8_t  mm=conv2d(__TIME__+3), ss=conv2d(__TIME__+6);
boolean  initial = 1;
static const double LONDON_LAT = 51.508131, LONDON_LON = -0.128002;
unsigned long distanceKmToLondon = (unsigned long)
         TinyGPSPlus::distanceBetween(
         gps.location.lat(),gps.location.lng(),LONDON_LAT,LONDON_LON)/1000;
double   courseToLondon = TinyGPSPlus::courseTo(
         gps.location.lat(),gps.location.lng(),LONDON_LAT,LONDON_LON);
const char *cardinalToLondon = TinyGPSPlus::cardinal(courseToLondon);
int      ym, dm, dd;                      // year,month,day
String   ym_, dm_, dd_, hh_, mm_, ss_;    // year,month,day,hour,min,sec
char     f1, f2, f3, b1, b2, b3;          // digital:year,month,day buffer
String   L1[11]={"0000/00/00","00:00:00","000.00" // old gps,time,date,,
            ,"000.00","000.00","000.00","000.00"
            ,"000.00","000.00","000.00"};
String   L2[11]={"0000/00/00","00:00:00","000.00" // new gps,time,date,,
            ,"000.00","000.00","000.00","000.00"
            ,"000.00","000.00","000.00"};
String   mode_ = "gps";                   // gps,digital,analog

//=========================================================================
void setup(){
  Serial.begin(115200);
  M5.begin();
  Wire.begin();
  gs.begin(9600);                   //static const uint32_t GPSBaud = 9600;
  M5.Lcd.fillScreen(BLACK);                                // DISPLAY CLEAR
  pinMode(BUTTON_A_PIN, INPUT_PULLUP);                     // Set A button
  pinMode(BUTTON_B_PIN, INPUT_PULLUP);                     // Set B button
  pinMode(BUTTON_C_PIN, INPUT_PULLUP);                     // Set C button
}

//=========================================================================
void loop(){ 
  if ( M5.BtnA.wasPressed()){ mode_ = "gps"    ; gps_setup()    ;}
  if ( M5.BtnB.wasPressed()){ mode_ = "analog" ; analog_setup() ;}
  if ( M5.BtnC.wasPressed()){ mode_ = "digital"; digital_setup();}
    
// gps mode -------------------------------------------------------------
if ( mode_ == "gps" ){                                     // GPS MODE
  if ( initial == 1 ){ gps_setup();}                       // INITIAL SET
  time_date_read();                                        // READ DATA 
 
  L2[0] = String(dd_ + "." + dm_ + "." + gps.date.year()); // DATE
  L2[1] = hh_ + ":" + mm_ + ":" + ss_;                     // TIME
  L2[2] = String(gps.location.lat(),6);                    // LAT
  L2[3] = String(gps.location.lng(),6);                    // LNG
  L2[4] = String(gps.satellites.value())    + " Sats";     // SATS
  L2[5] = String(gps.speed.kmph())          + " Km/h";     // SPEED
  L2[6] = String(gps.course.deg())          + " deg";      // CRS
  L2[7] = String(gps.altitude.meters())     + " m";        // ALT
  L2[8] = String(gps.hdop.value());                        // HDOP
  L2[9] = String(M5.Power.getBatteryLevel())+ " %";        // BATT
 
  M5.Lcd.setFreeFont(FM12); 
  for ( int i = 0; i < 11; i++ ){                          // DISPLAY
    M5.Lcd.setTextColor(BLACK, BLACK);
    M5.Lcd.drawString( L1[i], 100, 0 + ( 24 * i ));        // ERASE
    M5.Lcd.setTextColor( WHITE, BLACK);
    if (gps.location.lat() > 0){ M5.Lcd.setTextColor(GREEN,BLACK);} // RX
    M5.Lcd.drawString( L2[i], 100, 0 + ( 24 * i ));        // DRAW
    L1[i] = L2[i];                                         // SAVE
  } 
  smartDelay(1000);
 }
  
// analog mode  -----------------------------------------------------------
 if ( mode_ == "analog" ){                                 // ANALOG MODE
  time_date_read();                                        // READ DATA  
  sdeg = ss*6;                     // 0-59 -> 0-354   Pre-compute
  mdeg = mm*6+sdeg*0.01666667;     // 0-59 -> 0-360 - includes seconds
  hdeg = hh*30+mdeg*0.0833333;     // 0-11 -> 0-360 - inc min and seconds
  hx = cos((hdeg-90)*0.0174532925); hy = sin((hdeg-90)*0.0174532925);
  mx = cos((mdeg-90)*0.0174532925); my = sin((mdeg-90)*0.0174532925);
  sx = cos((sdeg-90)*0.0174532925); sy = sin((sdeg-90)*0.0174532925);
 
  M5.Lcd.drawLine(ohx, ohy, 160, 121, TFT_BLACK);          // ERASE HOUR
  M5.Lcd.drawLine(omx, omy, 160, 121, TFT_BLACK);          // ERASE MIN
  M5.Lcd.drawLine(osx, osy, 160, 121, TFT_BLACK);          // ERASE SEC
  ohx = hx*62+161; ohy = hy*62+121;                        // NEW   HOUR
  omx = mx*84+160; omy = my*84+121;                        // NEW   MIN
  osx = sx*90+161; osy = sy*90+121;                        // NEW   MIN
  M5.Lcd.drawLine(ohx, ohy, 160, 121, TFT_WHITE);          // DRAW  HOUR
  M5.Lcd.drawLine(omx, omy, 160, 121, TFT_WHITE);          // DRAW  MIN 
  M5.Lcd.drawLine(osx, osy, 160, 121, TFT_RED  );          // DRAW  SEC
  M5.Lcd.fillCircle(160, 121, 3, TFT_RED);                 // DOT   CENTER
  smartDelay(1000); 
 }
  
// digital mode  ----------------------------------------------------------
 if ( mode_ == "digital" ){                                // DIGITAL MODE
  time_date_read();                                        // READ DATA                   
  L2[0] = String(dd_ + "." + dm_ + "." + gps.date.year()); // OLD DATA
  L2[1] = " " + hh_ + ":" + mm_ + ":" + ss_;               // NEW DATA
  M5.Lcd.setFreeFont(FMB24);                               // FONT
  for ( int i = 0; i < 2; i++ ){                           // DISPLAY
    M5.Lcd.setTextColor(TFT_BLACK, TFT_BLACK);             // BLACK
    M5.Lcd.drawString(L1[i], 20, 60 + ( 80 * i ));         // ERASE
    M5.Lcd.setTextColor(TFT_WHITE, TFT_BLACK);             // WHITE
    if (gps.location.lat() > 0){M5.Lcd.setTextColor(GREEN,BLACK);} // RX
    M5.Lcd.drawString(L2[i], 20, 60 + ( 80 * i ));         // DRAW
    L1[i] = L2[i];                                         // SAVE
  }
 smartDelay(1000); 
 }
 M5.update();
}                                                          // END OF MAIN

//=========================================================================
static void smartDelay(unsigned long ms){
  unsigned long start = millis();
  do{ while (gs.available())
      gps.encode(gs.read());
  } while (millis() - start < ms);
  if (millis() > 5000 && gps.charsProcessed() < 10){none_gps();}
}

//=========================================================================
static uint8_t conv2d(const char* p){
  uint8_t v = 0;
  if ('0' <= *p && *p <= '9'){v = *p - '0';}
  return 10 * v + *++p - '0';
}

//=========================================================================
void gps_setup(){                                          // GPS  SETUP
  M5.Lcd.fillScreen(TFT_BLACK);                            // CLEAR DISPLAY
  M5.Lcd.setFreeFont(FM12);                                // FONT
  M5.Lcd.setTextColor(TFT_WHITE, TFT_BLACK);               // GPS  TITLE
  String L[11] = {"DATE","TIME","LAT","LNG","SATS"         // GPS  TITLE
                    ,"SPEED","CRS","ALT","HDOP","BATT"};   // GPS  TITLE
  for ( int i = 0; i < 11; i++ ){
    M5.Lcd.setCursor (     5, 0 + ( 24 * i ));
    M5.Lcd.drawString(L[i],5, 0 + ( 24 * i ));             // DRAW TITLE
  } 
  initial = 0;
}

//=========================================================================
void analog_setup(){                                       // ANALOG SETUP
  M5.Lcd.fillScreen(TFT_BLACK);                            // CLEAR DISPLAY
  M5.Lcd.setTextColor(TFT_WHITE, TFT_BLACK);
  M5.Lcd.fillCircle( 160, 120, 118, TFT_GREEN);            // CLOCK FACE
  M5.Lcd.fillCircle( 160, 120, 110, TFT_BLACK);            // LOCK FACE
  for(int i = 0; i<360; i+= 30) {                          // 12 LINES
    sx = cos((i-90)*0.0174532925);
    sy = sin((i-90)*0.0174532925);
    x0 = sx*114 + 160; yy0 = sy*114 + 120;
    x1 = sx*100 + 160; yy1 = sy*100 + 120;
    M5.Lcd.drawLine(x0, yy0, x1, yy1, TFT_GREEN);          // DRAW 12 LINES
  }
  for(int i = 0; i<360; i+= 6) {                           // 60 DOTS
    sx = cos((i-90)*0.0174532925);
    sy = sin((i-90)*0.0174532925);
    x0 = sx*102 + 160; yy0 = sy*102 + 120;
    M5.Lcd.drawPixel(x0, yy0, TFT_WHITE);                  // MINUTE
    if(i== 0 || i==180)M5.Lcd.fillCircle(x0,yy0,2,WHITE);  // DOTS
    if(i==90 || i==270)M5.Lcd.fillCircle(x0,yy0,2,WHITE);  // DOTS
  }
  M5.Lcd.fillCircle(160, 121, 3, TFT_RED);                 // DOTS CENTER
  M5.Lcd.drawJpgFile(SD, "/apple_marks/apple_50.jpg");     // apple ICON
  targetTime = millis() + 1000; 
}

//=========================================================================
void digital_setup(){
  M5.Lcd.fillScreen(TFT_BLACK); return;
}

//=========================================================================
void time_date_read(){                           // READ YY.MM.DD, HH,MM,SS
  if (gps.location.lat() > 0){ M5.Lcd.fillCircle(315,5,5,GREEN);} // Rx
  if (gps.location.lat() < 1){ M5.Lcd.fillCircle(315,5,5,RED  );} // not Rx
  ym = gps.date.year();  ym_ = String(ym);
  dm = gps.date.month(); dm_ = String(dm); if (dm < 10){ dm_="0"+dm_;}
  dd = gps.date.day();   dd_ = String(dd); if (dd < 10){ dd_="0"+dd_;}
  ss = gps.time.second();ss_ = String(ss); if (ss < 10){ ss_="0"+ss_;}
  mm = gps.time.minute();mm_ = String(mm); if (mm < 10){ mm_="0"+mm_;}
  hh = gps.time.hour();

//Serial.print("HH1: "); Serial.println(hh);
          if( hh < 22 ) { hh = hh+2;  }                  // MESZ
     else if( hh > 21 ) { hh = hh-22; }                  // MESZ 
//        if( hh < 23 ) { hh = hh+1;  }                  // MEZ
//   else if( hh > 22 ) { hh = hh-23; }                  // MEZ 
t:hh_ = String(hh); if (hh < 10){ hh_ = "0" + hh_;}      // ADD ZERO
//Serial.print("HH2: "); Serial.println(hh);
}

//=========================================================================
void none_gps(){                                           // NONE GPS
  M5.Lcd.setFreeFont(FMB24);                               // FONT
  M5.Lcd.setTextColor(RED, BLACK);
  M5.Lcd.drawString("No GPS data received:", 20, 50);      // MESSAGE
  M5.Lcd.drawString("check wiring", 20, 130);              // MESSAGE
}
//=========================================================================
