// original program by CesarSound 
// https://www.hackster.io/CesarSound/10khz-to-120mhz-vfo-rf-generator-with-si5351-and-arduino-3a7cad
// modified for quickly finding Si5351 calibration values; named "CALFINDER" 
// by Klaus Hirschelmann ( dj7oo@t-online.de )

//Libraries
#include <Wire.h>                 //IDE Standard
#include <Rotary.h>               //Ben Buxton https://github.com/brianlow/Rotary
#include <si5351.h>               //Etherkit https://github.com/etherkit/Si5351Arduino
#include <Adafruit_GFX.h>         //Adafruit GFX https://github.com/adafruit/Adafruit-GFX-Library
#include <Adafruit_SSD1306.h>     //Adafruit SSD1306 https://github.com/adafruit/Adafruit_SSD1306

//User preferences
//------------------------------------------------------------------------------------------------------------
#define FREQ_INIT  144500000 //Enter output frequency of your choice in "Hz"
#define XT_CAL_F   0         //Si5351 starting calibration factor
#define step   8             //Change the pin used by encoder push button if you want.
//------------------------------------------------------------------------------------------------------------

Rotary r = Rotary(2, 3);
Adafruit_SSD1306 display = Adafruit_SSD1306(128, 64, &Wire);
Si5351 si5351;

unsigned long freq = FREQ_INIT;
unsigned long cal_old, fstep;
long cal = XT_CAL_F;
byte encoder = 1;
byte stp;
unsigned int period = 100;   //millis display active
unsigned long time_now = 0;  //millis display active

ISR(PCINT2_vect) {
  char result = r.process();
  if (result == DIR_CW) set_cal(1);
  else if (result == DIR_CCW) set_cal(-1);
}

/////////////////////////////////////////////////////
// limit cal values for being between -300000 and +300000
void set_cal(short dir) {
  if (encoder == 1) {                         //Up/Down frequency
    if (dir == 1) cal = cal + fstep;
    if (cal >= 300000) cal = 300000;
    if (dir == -1) cal = cal - fstep;
    if (cal == 1000000 && cal <= 1000000) cal = 1000000;
    else if (cal < -300000) cal = -300000;
  }
}

//////////////////////////////////////////////////////////////
void setup() {
  Wire.begin();
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.clearDisplay();
  display.setTextColor(WHITE);
  display.display();

  pinMode(2, INPUT_PULLUP);   
  pinMode(3, INPUT_PULLUP);
  pinMode(step, INPUT_PULLUP);

  startup_text();

//  si5351.init(SI5351_CRYSTAL_LOAD_8PF, 27000000, 0); // use for 27 MHz crystals
    si5351.init(SI5351_CRYSTAL_LOAD_8PF, 0, 0);        // use for 25 MHz crystals
  si5351.set_correction(cal, SI5351_PLL_INPUT_XO);
  si5351.drive_strength(SI5351_CLK0, SI5351_DRIVE_8MA);
  si5351.output_enable(SI5351_CLK0, 1);    // 1=Enable 0=Disable 
  si5351.output_enable(SI5351_CLK1, 0);
  si5351.output_enable(SI5351_CLK2, 0);

  PCICR |= (1 << PCIE2);
  PCMSK2 |= (1 << PCINT18) | (1 << PCINT19);
  sei();

  stp = 4;
  setstep();
  displaycal();
}

/////////////////////////////////////////////////////////
void loop() {
  if (cal_old != cal) {
    time_now = millis();
    tunegen();
    cal_old = cal;
  }

  if (digitalRead(step) == LOW) {
    time_now = (millis() + 300);
    setstep();
    delay(300);
  }

  if ((time_now + period) > millis()) {
     displaycal();
 //    layout();
   }
}

////////////////////////////////////////////////////////////////////
void tunegen() {
  si5351.set_correction(cal, SI5351_PLL_INPUT_XO);
  si5351.set_freq(freq * 100ULL, SI5351_CLK0);
}

////////////////////////////////////////////////////////////////////
void displaycal() {
  display.clearDisplay();
  display.setTextSize(2);
  display.setCursor(10,0);
  display.print("CALFINDER");
  display.setCursor(0, 30);
  if(cal<-99999){ display.print("Cal"); }
  else { display.print("Cal:"); }
  display.print(cal);

  display.setCursor(0, 50);
  display.print("Stp:");
  if (stp == 1) display.print("10000");
  if (stp == 2) display.print("1"); 
  if (stp == 3) display.print("10"); 
  if (stp == 4) display.print("100");
  if (stp == 5) display.print("1000"); 
  display.display();
}

///////////////////////////////////////////////////////////////////////
void setstep() {
  switch (stp) {
    case 1:
      stp = 2;
      fstep = 1;
      break;
    case 2:
      stp = 3;
      fstep = 10;
      break;
    case 3:
      stp = 4;
      fstep = 100;
      break;
    case 4:
      stp = 5;
      fstep = 1000;
      break;
    case 5:
      stp = 1;
      fstep = 10000;
      break;
  }
}

/////////////////////////////////////////////////////////
void startup_text() {
  display.setTextSize(1);
  display.setCursor(1, 5);
  display.print("Si5351 CALFINDER");
  display.setCursor(1, 20);
  display.print("Orig: CesarSound");
  display.setCursor(1, 35);
  display.print("Modif. by DJ7OO");
  display.setCursor(1, 50);
  display.print("Vers.1.0 11/2022");
  display.display();
  delay(3000);
  display.clearDisplay();
}
